<?php $__env->startSection('styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">List</h1>
    <div>
        <ol class="breadcrumb">
            <!-- <li class="breadcrumb-item"><a href="javascript:void(0)">Tables</a></li> -->
            <li class="breadcrumb-item active" aria-current="page">List</li>
        </ol>
    </div>
</div>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">List</h3>
            </div>
            <div class="card-body">
                <a href="<?php echo e(url('admin/createtechnology')); ?>"> <button id="table2-new-row-button" class="btn btn-primary mb-4"> Add New</button></a>
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom" id="responsive-datatable">
                        <thead>
                            <tr>
                                <th class="wd-15p border-bottom-0">S.No</th>
                                <th class="wd-15p border-bottom-0">Title</th>
                                <th class="wd-15p border-bottom-0">Description</th>
                                <th class="wd-15p border-bottom-0">Status</th>
                                <th class="wd-10p border-bottom-0">Created Date</th>
                                <th class="wd-25p border-bottom-0">Action</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php if(@$list): ?>
                            <?php $__currentLoopData = @$list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                                                    
                            <tr>                                                        
                                <td><?php echo e($key+1); ?></td>
                                <td><?php echo e($data->title); ?></td>
                                <td><?php echo e(\Illuminate\Support\Str::words(strip_tags($data->description), 10,'....')); ?></td>
                                <td><?php if($data->status==0): ?> <span class="badge bg-success-transparent rounded-pill text-success p-2 px-3">Active </span> <?php else: ?> <span class="badge bg-danger-transparent rounded-pill text-danger p-2 px-3">De-Active </span> <?php endif; ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($data->created_at)->format('d/m/Y h:i')); ?></td>                                 
                                <td class="text-center align-middle">
                                    <div class="btn-group align-top">
                                        <a class="btn text-primary btn-sm" href="<?php echo e(url('admin/updatetechnology/'.$data->id)); ?>"><span class="fe fe-edit fs-14" data-target="#user-form-modal" data-bs-toggle="" type="button">Edit</span></a>
                                        <!--  <input type='button' class="btn btn-warning mt-2" value='Warning alert' id='click1'> -->
                                       <!--  <a class="btn text-danger btn-sm" href="<?php echo e(url('admin/deletetechnology/'.$data->id)); ?>"><span class="fe fe-trash-2 fs-14" type="button" data-bs-original-title="Delete"></span></a> -->
                                    </div>
                                </td>   
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>    

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Row -->
<!-- End Row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<!-- Select2 js-->
<script src="<?php echo e(asset('assets/plugins/select2/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/select2.js')); ?>"></script>

<!-- DATA TABLE JS-->
<script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/buttons.bootstrap5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/jszip.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/pdfmake/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/pdfmake/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/buttons.colVis.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/responsive.bootstrap5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/table-data.js')); ?>"></script>

<!-- INTERNAL Edit-Table JS -->
   <!--  <script src="<?php echo e(asset('assets/plugins/edit-table/bst-edittable.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/edit-table/edit-table.js')); ?>"></script> -->
    <script type="text/javascript">
    </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bumilink\resources\views/admin/our_solution_list.blade.php ENDPATH**/ ?>