<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminAuthController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\FollowingServicesController;
use App\Http\Controllers\Admin\ContactbyController;
use App\Http\Controllers\Admin\HeardaboutController;
use App\Http\Controllers\Admin\SociallinkController;
use App\Http\Controllers\Admin\UsefullinkController;
use App\Http\Controllers\Admin\SolutionsController;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\Admin\FeedbackController;
use App\Http\Controllers\Admin\QuoteController;
use App\Http\Controllers\Admin\OurTechnologyController;
use App\Http\Controllers\Admin\OurBusinessController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

    //front end
    Route::get('/', [FrontController::class, 'index']);
    Route::get('contact', [FrontController::class, 'contact']);
    Route::get('about', [FrontController::class, 'about']);
    Route::get('services', [FrontController::class, 'services']);
    Route::get('getaquote', [FrontController::class, 'getaquote']);
    Route::post('getaquote', [FrontController::class, 'savegetaquote']);
    Route::get('domesticservices', [FrontController::class, 'domesticservices']);
    Route::get('international', [FrontController::class, 'international']);
    Route::get('crossborderexpress', [FrontController::class, 'crossborderexpress']);
    Route::get('globallogistic', [FrontController::class, 'globallogistic']);
    Route::get('custombrokerage', [FrontController::class, 'custombrokerage']);
    Route::get('cargoinsurance', [FrontController::class, 'cargoinsurance']);
   /* Route::get('apparel', [FrontController::class, 'apparel']);
    Route::get('aviation', [FrontController::class, 'aviation']);
    Route::get('banking', [FrontController::class, 'banking']);
    Route::get('ecommerce', [FrontController::class, 'ecommerce']);
    Route::get('fmcg', [FrontController::class, 'fmcg']);
    Route::get('healthcaremedicallogistics', [FrontController::class, 'healthcaremedicallogistics']);
    Route::get('manufacturinglogistics', [FrontController::class, 'manufacturinglogistics']);
    Route::get('technology', [FrontController::class, 'technology']);
    Route::get('customstaxconsultancy', [FrontController::class, 'customstaxconsultancy']);
    Route::get('dedicatedfleetlogistics', [FrontController::class, 'dedicatedfleetlogistics']);
    Route::get('supplychainmanagement', [FrontController::class, 'supplychainmanagement']);
    Route::get('wms', [FrontController::class, 'wms']);*/
    Route::get('track', [FrontController::class, 'track']);
    Route::get('solutions', [FrontController::class, 'solutions']);
    Route::get('solutions/{name}', [FrontController::class, 'singlesolutionsdata']);
    Route::post('savefeedback', [FrontController::class, 'SaveFeedback']);
    //end front end
    Route::group(['prefix' => 'admin', 'namespace' => 'Admin'], function () {
    Route::get('/login', [AdminAuthController::class, 'getLogin'])->name('adminLogin');
    Route::post('/login', [AdminAuthController::class, 'postLogin'])->name('adminLoginPost');
    Route::get('/logout', [AdminAuthController::class, 'getLogout']);
    Route::get('/forgotpassword', [AdminAuthController::class, 'forgotPassword'])->name('forgotpassword');
    Route::post('/forgotpassword', [AdminAuthController::class, 'gentrateUserPassword'])->name('forgotpassword');

    Route::group(['middleware' => 'adminauth'], function () {
        //dashboard
        Route::get('/', function () {
            return view('admin.index');                                    
        })->name('adminDashboard');
        //user list
        Route::get('/users', [UserController::class, 'userslist']);
        Route::get('/createuser', [UserController::class, 'createuser']);
        Route::post('/saveuser', [UserController::class, 'saveuser']);
        Route::get('/updateuser/{id}', [UserController::class, 'updateuser']);
        Route::post('/updateuser/{id}', [UserController::class, 'edituser']);
        Route::get('/deleteuser/{id}', [UserController::class, 'deleteuser']);
        //settings
        Route::get('/settings', [SettingsController::class, 'settings']);
        Route::post('/settings', [SettingsController::class, 'savesettings']);
        //following services
        Route::get('/followingservices', [FollowingServicesController::class, 'listdata']);
        Route::get('/createfollowingservices', [FollowingServicesController::class, 'createdata']);
        Route::post('/savefollowingservices', [FollowingServicesController::class, 'savedata']);
        Route::get('/updatefollowingservice/{id}', [FollowingServicesController::class, 'viewdata']);
        Route::post('/updatefollowingservice/{id}', [FollowingServicesController::class, 'updatedata']);
        Route::get('/deletefollowingservice/{id}', [FollowingServicesController::class, 'deletedata']);
        //contactBy
        Route::get('/contactby', [ContactbyController::class, 'listdata']);
        Route::get('/createcontactby', [ContactbyController::class, 'createdata']);
        Route::post('/savecontactby', [ContactbyController::class, 'savedata']);
        Route::get('/updatecontactby/{id}', [ContactbyController::class, 'viewdata']);
        Route::post('/updatecontactby/{id}', [ContactbyController::class, 'updatedata']);
        Route::get('/deletecontactby/{id}', [ContactbyController::class, 'deletedata']);
        //contactBy
        Route::get('/heardabout', [HeardaboutController::class, 'listdata']);
        Route::get('/createheardabout', [HeardaboutController::class, 'createdata']);
        Route::post('/saveheardabout', [HeardaboutController::class, 'savedata']);
        Route::get('/updateheardabout/{id}', [HeardaboutController::class, 'viewdata']);
        Route::post('/updateheardabout/{id}', [HeardaboutController::class, 'updatedata']);
        Route::get('/deleteheardabout/{id}', [HeardaboutController::class, 'deletedata']);
        //sociallink
        Route::get('/sociallink', [SociallinkController::class, 'listdata']);
        Route::get('/createsociallink', [SociallinkController::class, 'createdata']);
        Route::post('/savesociallink', [SociallinkController::class, 'savedata']);
        Route::get('/updatesociallink/{id}', [SociallinkController::class, 'viewdata']);
        Route::post('/updatesociallink/{id}', [SociallinkController::class, 'updatedata']);
        Route::get('/deletesociallink/{id}', [SociallinkController::class, 'deletedata']);
        //useful links
        Route::get('/usefullink', [UsefullinkController::class, 'listdata']);
        Route::get('/createuseful', [UsefullinkController::class, 'createdata']);
        Route::post('/saveuseful', [UsefullinkController::class, 'savedata']);
        Route::get('/updateusefullink/{id}', [UsefullinkController::class, 'viewdata']);
        Route::post('/updateusefullink/{id}', [UsefullinkController::class, 'updatedata']);
        Route::get('/deleteusefullink/{id}', [UsefullinkController::class, 'deletedata']);
        //solutions
        Route::get('/solutions', [SolutionsController::class, 'listdata']);
        Route::get('/createsolutions', [SolutionsController::class, 'createdata']);
        Route::post('/savesolutions', [SolutionsController::class, 'savedata']);
        Route::get('/updateusolutions/{id}', [SolutionsController::class, 'viewdata']);
        Route::post('/updateusolutions/{id}', [SolutionsController::class, 'updatedata']);
        //user feedback
        Route::get('/userfeedback', [FeedbackController::class, 'listdata']);
        Route::get('/userfeedbackview/{id}', [FeedbackController::class, 'viewdata']);
        //user feedback
        Route::get('/quote', [QuoteController::class, 'listdata']);
        Route::get('/quoteview/{id}', [QuoteController::class, 'viewdata']);
        //Our Technology
        Route::get('/ourtechnology', [OurTechnologyController::class, 'listdata']);
        Route::get('/createtechnology', [OurTechnologyController::class, 'createdata']);
        Route::post('/savetechnology', [OurTechnologyController::class, 'savedata']);
        Route::get('/updatetechnology/{id}', [OurTechnologyController::class, 'viewdata']);
        Route::post('/updatetechnology/{id}', [OurTechnologyController::class, 'updatedata']);
        //our business
        Route::get('/ourbussiness', [OurBusinessController::class, 'listdata']);
        Route::get('/creatourbussiness', [OurBusinessController::class, 'createdata']);
        Route::post('/saveourbussiness', [OurBusinessController::class, 'savedata']);
        Route::get('/updateourbussiness/{id}', [OurBusinessController::class, 'viewdata']);
        Route::post('/updateourbussiness/{id}', [OurBusinessController::class, 'updatedata']);

    });
});