<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\Usefullink;
use App\Models\Sociallink;
use App\Models\Settings;
use App\Models\OurTechnology;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //header and footer values get
         View::composer('*', function ($view) {
          $sitesetting = Settings::first();
          $usefullink = Usefullink::where('status','0')->where('deleted_at',null)->get();
          $sociallink = Sociallink::where('status','0')->where('deleted_at',null)->get();
          $ourtechnology = OurTechnology::where('status','0')->where('deleted_at',null)->get();
          $view->with('usefullink',$usefullink)->with('setting',$sitesetting)->with('sociallink',$sociallink)->with('ourtechnology',$ourtechnology);
         });
    }
}
