<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;
use App\Models\FollowingServices;
use App\Models\Contactby;
use App\Models\Heardabout;
use App\Models\Country;
use App\Models\UserFeedback;
use App\Models\UserFeedbackFollowingService;
use App\Models\UserFeedbackContactBy;
use App\Models\Solutions;
use App\Models\Quote;

class FrontController extends Controller
{
    public function index(){
        return view('index');
    }
    public function getaquote(){
        $country = Country::where('nicename','!=','')->select('nicename')->get();
        return view('getaquote',compact('country'));
    }
    public function about(){ 
        return view('about');
    }public function services(){ 
        return view('services');
    }public function domesticservices(){ 
        return view('domesticservices');
    }public function international(){ 
        return view('international');
    }public function crossborderexpress(){ 
        return view('crossborderexpress');
    }public function globallogistic(){ 
        return view('globallogistic');
    }public function custombrokerage(){ 
        return view('custombrokerage');
    }public function cargoinsurance(){ 
        return view('cargoinsurance');
    }

    /*public function apparel(){ 
        return view('apparel');
    }public function aviation(){ 
        return view('aviation');
    }public function banking(){ 
        return view('banking');
    }public function ecommerce(){ 
        return view('ecommerce');
    }public function fmcg(){ 
        return view('fmcg');
    }public function healthcaremedicallogistics(){
        return view('healthcaremedicallogistics');
    }public function manufacturinglogistics(){
        return view('manufacturinglogistics');
    }public function technology(){
        return view('technology');
    }public function customstaxconsultancy(){
        return view('customstaxconsultancy');
    }public function dedicatedfleetlogistics(){
        return view('dedicatedfleetlogistics');
    }public function supplychainmanagement(){
        return view('supplychainmanagement');
    }public function wms(){
        return view('wms');
    }*/

    public function track(){
        return view('track');
    }public function solutions(){
        $data=Solutions::where('deleted_at',null)->get();
        return view('solutions',compact('data'));
    }public function singlesolutionsdata(Request $request, $ulrname){
        $data=Solutions::where('page_url',$ulrname)->where('deleted_at',null)->first();
        if(is_object($data)){
           return view($ulrname,compact('data'));
        }
        return redirect('solutions');
    }
    public function contact(){
        $following_services = FollowingServices::where('status','0')->where('deleted_at',null)->get();
        $contactby = Contactby::where('status','0')->where('deleted_at',null)->get();
        $heredabout = Heardabout::where('status','0')->where('deleted_at',null)->get();
        $country = Country::orderBy('name', 'ASC')->get();
        return view('contact',compact('following_services','contactby', 'heredabout','country'));
    }
    public function savegetaquote(Request $request){
        
        $validated = Validator::make($request->all(),[        
        'myfile' => 'required|max:2048'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        $name = $request->file('myfile')->getClientOriginalName();
        $path = $request->file('myfile')->store('public/images/getaquote');
        //create data
        $quota = new Quote();
        $quota->company_name  = $request->user_companyname;
        $quota->company_email  = $request->user_email;
        $quota->user_name  = $request->user_name;
        $quota->file_name  = $name;
        $quota->details  = json_encode($request->all());
        $quota->quote_type  = 'Unread';
        $quota->file  = explode ("/", $path)[3];
        $quota->save();
       
        return redirect('getaquote')->with('success','Added sucessfully.');
    } 

    public function SaveFeedback(Request $request){
        //dd($request->all());
        $validated = Validator::make($request->all(),[
        'firstname' => 'required',
        //'lastname' => 'required',
        'company' => 'required',
        'title' => 'required',
        'mobile' => 'required',
        'email' => 'required',
        'country' => 'required',
        'address' => 'required',
        'postal' => 'required',
        'city' => 'required',
        'state' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        //create data
        $userFeedback = new UserFeedback();
        $userFeedback->firstname = $request->firstname;
        $userFeedback->lastname  = ($request->lastname)? $request->lastname:'';
        $userFeedback->company_name  = $request->company;
        $userFeedback->company_title  = $request->title;
        $userFeedback->phone  = ($request->phone) ? $request->phone : '';
        $userFeedback->email  = $request->email;
        $userFeedback->country  = $request->country;
        $userFeedback->fax  = ($request->fax) ? $request->fax : '';
        $userFeedback->mobile  = ($request->mobile) ? $request->mobile : '';      
        $userFeedback->address  = ($request->address) ? $request->address : '';
        $userFeedback->postal  = ($request->postal) ? $request->postal : '';
        $userFeedback->city  = ($request->city) ? $request->city : '';
        $userFeedback->state  = ($request->state) ? $request->state : '';    
        $userFeedback->heardabout  = ($request->heardabout) ? $request->heardabout : '';    
        $userFeedback->message  = ($request->message) ? $request->message : '';
        $userFeedback->message_type  = 'Unread';
        $userFeedback->save();
        if(is_countable($request->followingservice) && count($request->followingservice)>0){
            foreach ($request->followingservice as $key => $value) {
             $followingdata = new UserFeedbackFollowingService();
             $followingdata->feedback_id = $userFeedback->id;
             $followingdata->following_services_id = $value;
             $followingdata->save();
            }      
         }
        if(is_countable($request->contactby) && count($request->contactby) >0){
            foreach ($request->contactby as $key => $value) {
             $contactby = new UserFeedbackContactBy();
             $contactby->feedback_id = $userFeedback->id;
             $contactby->contact_by_id = $value;
             $contactby->save();
            }            
         }
        return redirect('contact')->with('success','Added sucessfully.');
    } 
}