<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use App\Models\Admintypes;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;

class UserController extends Controller
{
    public function userslist(){
        $userlist = Admin::where('deleted_at',null)->get();
        return view('admin.userlists',compact('userlist'));
    }
    public function createuser(){
        $admintypes =  Admintypes::select('id','type')->where('status','0')->get();
        return view('admin.createuser',compact('admintypes'));
    }
    public function updateuser($id){
        $getuserData = Admin::findOrFail($id);
        $admintypes =  Admintypes::select('id','type')->where('status','0')->get();
        return view('admin.updateuser',compact('admintypes','getuserData'));
    } 
    public function deleteuser(Request $request, $id){        
        $getuserData = Admin::findOrFail($id);
        $getuserData->deleted_at = Carbon::now();
        $getuserData->save();        
        return redirect('admin/users')->with('success','Deleted sucessfully.');
    }
    //create user
    public function saveuser(Request $request)
    {//dd($request->all());
        $validated = Validator::make($request->all(),[
        'firstname' => 'required|max:100',
        'lastname' => 'required|max:100',
        'number' => 'required|max:100',
        'email' => 'email|unique:admins,email',
        'usertype' => 'required',
        'password' => 'min:5|required_with:password_confirmation|same:password_confirmation',
        'password_confirmation' => 'min:5'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        //create data
        $user = new Admin();
        $user->firstname = $request->firstname;
        $user->lastname  = $request->lastname;
        $user->number    = $request->number;
        $user->email     = $request->email;
        $user->password  = bcrypt($request->password);
        $user->admin_type_id  = $request->usertype;
        $user->status  = '1';
        $user->save();
        return redirect('admin/users')->with('success','Added sucessfully.');
    }
    //create user
    public function edituser(Request $request, $id)
    {
        $validated = Validator::make($request->all(),[
        'firstname' => 'required|max:100',
        'lastname' => 'required|max:100',
        'number' => 'required|max:100',
        'email' => 'email|unique:admins,email,'.$id,
        'usertype' => 'required'/*,
        'password' => 'min:5|required_with:password_confirmation|same:password_confirmation',
        'password_confirmation' => 'min:5'*/
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        
        //update data
        $user = Admin::find($id);
        if(isset($request->password)){ $password=bcrypt($request->password);}else{$password=$user->password;};
        $user->firstname = $request->firstname;
        $user->lastname  = $request->lastname;
        $user->number    = $request->number;
        $user->email     = $request->email;
        $user->password  = $password;
        $user->admin_type_id  = $request->usertype;
        $user->status  = $request->status;
        $user->save();
        return redirect('admin/users')->with('success','updated sucessfully.');
    }

}