<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use App\Models\Admintypes;
use App\Models\Usefullink;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;

class UsefullinkController extends Controller
{
    //index
    public function listdata(){
        $list = Usefullink::where('deleted_at',null)->orderBy('id', 'DESC')->get();
        return view('admin.useful_link_list',compact('list'));
    }
    //create
    public function createdata(){
        return view('admin.create_useful_link');
    }
    //view
    public function viewdata($id){
        $data =  Usefullink::findOrFail($id);
        return view('admin.update_useful_link',compact('data'));
    }
    //delete
    public function deletedata(Request $request, $id){        
        $getuserData = Usefullink::findOrFail($id);
        $getuserData->deleted_at = Carbon::now();
        $getuserData->save();        
        return redirect('admin/usefullink')->with('success','Deleted sucessfully.');
    }
    //create
    public function savedata(Request $request)
    {
        $validated = Validator::make($request->all(),[
        'name' => 'required|min:5|unique:useful_llink,name',
        /*'link' => 'required',*/
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        //create data
        $user = new Usefullink();
        $user->name = $request->name;
        $user->status  = $request->status;
        $user->link  = ($request->link) ? $request->link : '';
        $user->hover  = ($request->hover) ? $request->hover : '';
        $user->save();
        return redirect('admin/usefullink')->with('success','Added sucessfully.');
    }
    //update
    public function updatedata(Request $request, $id)
    {
         $validated = Validator::make($request->all(),[
        'name' => 'required|min:5|unique:useful_llink,name,'.$id,
        /*'link' => 'required',*/
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }        
        //update data
        $user = Usefullink::find($id);
        $user->name = $request->name;
        $user->link  = $request->link;
        $user->status  = $request->status;
        $user->hover  = ($request->hover) ? $request->hover : '';
        $user->save();
        return redirect('admin/usefullink')->with('success','updated sucessfully.');
    }

}