<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use App\Models\Admintypes;
use App\Models\Usefullink;
use App\Models\Solutions;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;

class SolutionsController extends Controller
{
    //index
    public function listdata(){
        $list = Solutions::where('deleted_at',null)->orderBy('id', 'DESC')->get();
        return view('admin.solutions_list',compact('list'));
    }
    //create
    public function createdata(){
        return view('admin.create_solutions');
    }
    //view
    public function viewdata($id){
        $data =  Solutions::findOrFail($id);
        return view('admin.update_solutions',compact('data'));
    }
    //delete
    /*public function deletedata(Request $request, $id){        
        $getuserData = Usefullink::findOrFail($id);
        $getuserData->deleted_at = Carbon::now();
        $getuserData->save();        
        return redirect('admin/usefullink')->with('success','Deleted sucessfully.');
    }*/
    //create
    public function savedata(Request $request)
    {
        $validated = Validator::make($request->all(),[
        'name' => 'required|min:3|unique:solutions,name',
        'file' => 'required|mimes:png,jpg,jpeg|max:2048',
        'page_url' => 'required',
        'description' => 'required',
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        //create data
        $name = $request->file('file')->getClientOriginalName();
        $path = $request->file('file')->store('public/images/solutions');
        $solution = new Solutions();
        $solution->name = $request->name;
        $solution->page_url  = strtolower($request->page_url);
        $solution->status  = $request->status;
        $solution->descriptions  = ($request->description) ? $request->description : '';
        $solution->image_name  = $name;
        $solution->image  = explode ("/", $path)[3];
        $solution->save();
        return redirect('admin/solutions')->with('success','Added sucessfully.');
    }
    //update
    public function updatedata(Request $request, $id)
    {
         $validated = Validator::make($request->all(),[
        'name' => 'required|min:3|unique:solutions,name,'.$id,
        'file' => 'sometimes|mimes:png,jpg,jpeg|max:2048',
        'description' => 'required',
        'page_url' => 'required',
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }        
        //update data
        $solution = Solutions::findOrFail($id);
        if($request->hasFile('file'))
         {
            //delete old files
            $old_path = 'public/images/solutions/'.$solution->image;
            if(Storage::disk('public')->exists('images/solutions/'.$solution->image)){
               Storage::disk('public')->delete('images/solutions/'.$solution->image);
             }
            //delete old files
            $name = $request->file('file')->getClientOriginalName(); 
            $path = $request->file('file')->store('public/images/solutions');
            $solution->image_name  = $name;
            $solution->image  = explode ("/", $path)[3];
         }
        $solution->name = $request->name;
        $solution->page_url  = strtolower($request->page_url);
        $solution->status  = $request->status;
        $solution->descriptions  = ($request->description) ? $request->description : '';        
        $solution->save();
        return redirect('admin/solutions')->with('success','updated sucessfully.');
    }

}