<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use App\Models\Admintypes;
use App\Models\Settings;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;

class SettingsController extends Controller
{
    public function settings(){
        $settingData = Settings::first();
        return view('admin.settings',compact('settingData'));
    }
    //create user
    public function savesettings(Request $request)
    {
        
        $validated = Validator::make($request->all(),[
        'sitename' => 'required|max:200',
        'sitelink' => 'required|max:200',
        'email' => 'required|max:100',
        'number' => 'required',
        'fax' => 'required',
        'address' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        //create data
        $data = Settings::count();
        if($data==0){
        $user = new Settings();
        $user->site_name = $request->sitename;
        $user->site_link  = $request->sitelink;
        $user->email    = $request->email;
        $user->phone     = $request->number;
        $user->fax  = $request->fax;
        $user->address  = $request->address;
        $user->save();
        }else{
        $user = Settings::first();
        $user->site_name = $request->sitename;
        $user->site_link  = $request->sitelink;
        $user->email    = $request->email;
        $user->phone     = $request->number;
        $user->fax  = $request->fax;
        $user->address  = $request->address;
        $user->save();
        }
        return redirect('admin/settings')->with('success','Added sucessfully.');
    }
    

}