<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use App\Models\Admintypes;
use App\Models\Heardabout;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;

class HeardaboutController extends Controller
{
    //index
    public function listdata(){
        $list = Heardabout::where('deleted_at',null)->orderBy('id', 'DESC')->get();
        return view('admin.heard_about_list',compact('list'));
    }
    //create
    public function createdata(){
        return view('admin.create_heard_about');
    }
    //view
    public function viewdata($id){
        $data =  Heardabout::findOrFail($id);
        return view('admin.update_heard_about',compact('data'));
    }
    //delete
    public function deletedata(Request $request, $id){        
        $getuserData = Heardabout::findOrFail($id);
        $getuserData->deleted_at = Carbon::now();
        $getuserData->save();        
        return redirect('admin/heardabout')->with('success','Deleted sucessfully.');
    }
    //create
    public function savedata(Request $request)
    {
        $validated = Validator::make($request->all(),[
        'name' => 'required|min:5|unique:contact_by,name',
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        //create data
        $user = new Heardabout();
        $user->name = $request->name;
        $user->status  = $request->status;
        $user->save();
        return redirect('admin/heardabout')->with('success','Added sucessfully.');
    }
    //update
    public function updatedata(Request $request, $id)
    {
         $validated = Validator::make($request->all(),[
        'name' => 'required|min:5|unique:contact_by,name,'.$id,
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }        
        //update data
        $user = Heardabout::find($id);
        $user->name = $request->name;
        $user->status  = $request->status;
        $user->save();
        return redirect('admin/heardabout')->with('success','updated sucessfully.');
    }

}