<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use App\Models\Admintypes;
use App\Models\FollowingServices;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;

class FollowingServicesController extends Controller
{
    //index
    public function listdata(){
        $list = FollowingServices::where('deleted_at',null)->orderBy('id', 'DESC')->get();
        return view('admin.followingservicelist',compact('list'));
    }
    //create
    public function createdata(){
        return view('admin.createfollowingservice');
    }
    //view
    public function viewdata($id){
        $data =  FollowingServices::findOrFail($id);
        return view('admin.updatefollowingservice',compact('data'));
    }
    //delete
    public function deletedata(Request $request, $id){        
        $getuserData = FollowingServices::findOrFail($id);
        $getuserData->deleted_at = Carbon::now();
        $getuserData->save();        
        return redirect('admin/followingservices')->with('success','Deleted sucessfully.');
    }
    //create
    public function savedata(Request $request)
    {
        $validated = Validator::make($request->all(),[
        'name' => 'required|min:5|unique:following_services,name',
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        //create data
        $user = new FollowingServices();
        $user->name = $request->name;
        $user->status  = $request->status;
        $user->save();
        return redirect('admin/followingservices')->with('success','Added sucessfully.');
    }
    //update
    public function updatedata(Request $request, $id)
    {
         $validated = Validator::make($request->all(),[
        'name' => 'required|min:5|unique:following_services,name,'.$id,
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }        
        //update data
        $user = FollowingServices::find($id);
        $user->name = $request->name;
        $user->status  = $request->status;
        $user->save();
        return redirect('admin/followingservices')->with('success','updated sucessfully.');
    }

}