<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use App\Models\Admintypes;
use App\Models\Contactby;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;

class ContactbyController extends Controller
{
    //index
    public function listdata(){
        $list = Contactby::where('deleted_at',null)->orderBy('id', 'DESC')->get();
        return view('admin.contact_by_list',compact('list'));
    }
    //create
    public function createdata(){
        return view('admin.create_contact_by');
    }
    //view
    public function viewdata($id){
        $data =  Contactby::findOrFail($id);
        return view('admin.update_contact_by',compact('data'));
    }
    //delete
    public function deletedata(Request $request, $id){        
        $getuserData = Contactby::findOrFail($id);
        $getuserData->deleted_at = Carbon::now();
        $getuserData->save();        
        return redirect('admin/contactby')->with('success','Deleted sucessfully.');
    }
    //create
    public function savedata(Request $request)
    {
        $validated = Validator::make($request->all(),[
        'name' => 'required|min:5|unique:contact_by,name',
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        //create data
        $user = new Contactby();
        $user->name = $request->name;
        $user->status  = $request->status;
        $user->save();
        return redirect('admin/contactby')->with('success','Added sucessfully.');
    }
    //update
    public function updatedata(Request $request, $id)
    {
         $validated = Validator::make($request->all(),[
        'name' => 'required|min:5|unique:contact_by,name,'.$id,
        'status' => 'required'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }        
        //update data
        $user = Contactby::find($id);
        $user->name = $request->name;
        $user->status  = $request->status;
        $user->save();
        return redirect('admin/contactby')->with('success','updated sucessfully.');
    }

}