<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use Hash;
use Validator;

class AdminAuthController extends Controller
{
    public function getLogin(){
        return view('admin.login');
    }

    public function postLogin(Request $request)
    {        
        $validated = Validator::make($request->all(),[
        'email' => 'required|email|max:100',
        'password' => 'required',
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput();
        }
        if(auth()->guard('admin')->attempt(['email' => $request->input('email'),  'password' => $request->input('password')])){
            $user = auth()->guard('admin')->user();            
            return redirect()->route('adminDashboard')->with('success','You are Logged in sucessfully.');           
        }else {
            return back()->withErrors($validated)
                        ->withInput()
                        ->with('error','Whoops! invalid email and password.');
        }
    }

    public function forgotPassword(){
        return view('admin.forgotpassword');
    }

    public function gentrateUserPassword(Request $request)
    {        
        $validated = Validator::make($request->all(),[
        'email' => 'required|email|max:100'
         ]);
        if ($validated->fails()) {
            return redirect()
                        ->back()
                        ->withErrors($validated)
                        ->withInput()
                        ->with('error','Whoops! invalid email and password.');
        }        
        return redirect()->back()->with('success','Email sent successfully please check your inbox');           
      
    }

    public function getLogout(Request $request)
    {
        auth()->guard('admin')->logout();
        Session::flush();
        Session::put('success', 'You are logout sucessfully');
        return redirect(route('adminLogin'));
    }
}